/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.datasource.Service;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.plugin.ServiceDescriptor;
import de.willuhn.jameica.security.SSLRMIClientSocketFactory;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.RegistryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Map;

public final class ServiceFactory {
    private Settings settings = new Settings(ServiceFactory.class);
    private Map<String, ServiceEntry> services = new HashMap<String, ServiceEntry>();

    public synchronized void init(Manifest manifest) throws ApplicationException {
        ServiceDescriptor[] descriptors = manifest.getServices();
        if (descriptors == null || descriptors.length == 0) {
            return;
        }
        Application.getCallback().getStartupMonitor().setStatusText("init services for plugin " + manifest.getName() + " [version: " + manifest.getVersion() + "]");
        for (int i = 0; i < descriptors.length; ++i) {
            String fullName = manifest.getPluginClass() + "." + descriptors[i].getName();
            if (this.services.get(fullName) != null) {
                Logger.debug((String)("service " + descriptors[i].getName() + " already started, skipping"));
                continue;
            }
            try {
                Application.getCallback().getStartupMonitor().setStatusText(manifest.getName() + ": init service " + descriptors[i].getName());
                Application.getCallback().getStartupMonitor().addPercentComplete(10);
                this.install(manifest, descriptors[i]);
                continue;
            }
            catch (Throwable t) {
                Logger.error((String)"error while initializing service, ", (Throwable)t);
                String s = t.getMessage();
                if (s == null || s.length() == 0) {
                    s = t.getClass().getName();
                }
                throw new ApplicationException(Application.getI18n().tr("Plugin \"{0}\" wurde aufgrund eines Fehlers bei der Initialisierung deaktiviert.\nFehlermeldung: " + s, manifest.getName()), t);
            }
        }
    }

    private void install(Manifest manifest, ServiceDescriptor descriptor) throws RemoteException {
        Application.getCallback().getStartupMonitor().setStatusText("install service " + descriptor.getName());
        Application.getCallback().getStartupMonitor().addPercentComplete(5);
        String name = descriptor.getName();
        String fullName = manifest.getPluginClass() + "." + name;
        if (this.services.get(fullName) != null) {
            Logger.debug((String)("service " + name + " already installed, skipping"));
            return;
        }
        try {
            Logger.info((String)("service: " + name));
            ServiceEntry entry = new ServiceEntry();
            entry.serviceClass = manifest.getClassLoader().load(descriptor.getClassname());
            this.services.put(fullName, entry);
            String[] depends = descriptor.depends();
            ServiceDescriptor[] deps = manifest.getServices();
            if (name != null && name.length() > 0 && depends != null && depends.length > 0 && deps != null && deps.length > 0) {
                Logger.info((String)"  dependencies found...");
                for (int i = 0; i < deps.length; ++i) {
                    for (int j = 0; j < depends.length; ++j) {
                        if (name.equals(depends[j]) || !depends[j].equals(deps[i].getName())) continue;
                        this.install(manifest, deps[i]);
                    }
                }
            }
            if (Application.inClientMode()) {
                Logger.info((String)"jameica runs in client mode, skipping service deployments");
                return;
            }
            entry.service = this.newInstance(manifest, entry.serviceClass);
            if (descriptor.share()) {
                RegistryService rs = (RegistryService)Application.getBootLoader().getBootable(RegistryService.class);
                rs.rebind(fullName, (Remote)entry.service);
            }
            if (!descriptor.autostart()) {
                Logger.info((String)"  autostart disabled, skipping service start");
                return;
            }
            if (entry.service.isStartable()) {
                Logger.info((String)"  starting service");
                Application.getCallback().getStartupMonitor().setStatusText("starting service " + name);
                entry.service.start();
            } else {
                Logger.info((String)"  service not startable");
            }
        }
        catch (Exception e) {
            throw new RemoteException("error while installing service " + name, e);
        }
    }

    private Service newInstance(Manifest manifest, Class serviceClass) throws Exception {
        Class impl = null;
        try {
            impl = manifest.getClassLoader().getClassFinder().findImplementors(serviceClass)[0];
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)("unable to find implementor for interface " + serviceClass.getName() + ", trying to load " + serviceClass.getName()));
        }
        if (impl == null) {
            impl = serviceClass;
        }
        BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        return (Service)beanService.get(impl);
    }

    public Service lookup(Class pluginClass, String serviceName) throws Exception {
        if (serviceName == null || pluginClass == null) {
            return null;
        }
        String fullName = pluginClass.getName() + "." + serviceName;
        Logger.debug((String)("searching for service " + serviceName + " for plugin " + pluginClass.getName()));
        ServiceEntry entry = this.services.get(fullName);
        if (entry == null) {
            throw new ApplicationException(Application.getI18n().tr("Der Service \"{0}\" wurde nicht gefunden", serviceName));
        }
        if (entry.service != null) {
            Logger.debug((String)"found local or cached remote service");
            return entry.service;
        }
        entry.remote = true;
        String host = this.getLookupHost(pluginClass, serviceName);
        int port = this.getLookupPort(pluginClass, serviceName);
        if (host == null || host.length() == 0 || port == -1) {
            Logger.error((String)("missing entry: " + serviceName + "=<hostname>:<port> in " + Application.getConfig().getConfigDir() + File.separator + ServiceFactory.class.getName() + ".properties"));
            throw new ApplicationException(Application.getI18n().tr("F\u00fcr den Service \"{0}\" ist kein Server definiert", serviceName));
        }
        Logger.debug((String)("searching for service at rmi://" + host + ":" + port + "/" + fullName));
        entry.service = Application.getConfig().getRmiSSL() ? (Service)LocateRegistry.getRegistry(host, port, new SSLRMIClientSocketFactory()).lookup(fullName) : (Service)LocateRegistry.getRegistry(host, port).lookup(fullName);
        return entry.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutDown(Plugin plugin) {
        if (Application.inClientMode()) {
            return;
        }
        Logger.info((String)"shutting down local services");
        ServiceDescriptor[] services = plugin.getManifest().getServices();
        if (services == null || services.length == 0) {
            return;
        }
        for (ServiceDescriptor s : services) {
            String fullName = plugin.getClass().getName() + "." + s.getName();
            ServiceEntry entry = this.services.get(fullName);
            if (entry == null || entry.service == null || entry.remote) continue;
            try {
                if (entry.service.isStarted()) {
                    Logger.info((String)("  " + s.getName()));
                    entry.service.stop(false);
                }
                if (!s.share()) continue;
                RegistryService rs = (RegistryService)Application.getBootLoader().getBootable(RegistryService.class);
                rs.unbind(fullName);
            }
            catch (Exception e) {
                Logger.error((String)"error while stopping service", (Throwable)e);
            }
            finally {
                this.services.remove(fullName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutDown() {
        Logger.info((String)"shutting down local services");
        try {
            for (String name : this.services.keySet()) {
                try {
                    ServiceEntry entry = this.services.get(name);
                    if (entry == null || entry.service == null || entry.remote || !entry.service.isStarted()) continue;
                    Logger.info((String)("  " + name));
                    entry.service.stop(false);
                }
                catch (Throwable t) {
                    Logger.error((String)("error while stopping service " + name), (Throwable)t);
                }
            }
        }
        finally {
            this.services.clear();
        }
    }

    public void setLookup(Class pluginclass, String serviceName, String host, int port) {
        String longName = pluginclass.getName() + "." + serviceName;
        if (host == null || host.length() == 0 || port == -1) {
            this.settings.setAttribute(longName, null);
        } else {
            this.settings.setAttribute(longName, host + ":" + port);
        }
        ServiceEntry entry = this.services.get(pluginclass.getName() + "." + serviceName);
        if (entry != null) {
            entry.service = null;
        }
    }

    public String getLookupHost(Class pluginclass, String serviceName) {
        String value = this.settings.getString(pluginclass.getName() + "." + serviceName, null);
        if (value == null) {
            return null;
        }
        return value.substring(0, value.lastIndexOf(":"));
    }

    public int getLookupPort(Class pluginclass, String serviceName) {
        String value = this.settings.getString(pluginclass.getName() + "." + serviceName, null);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value.substring(value.lastIndexOf(":") + 1));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private class ServiceEntry {
        private Service service = null;
        private Class serviceClass = null;
        private boolean remote = false;

        private ServiceEntry() {
        }
    }
}

